; ******************************************************
;             DC mBOT - Extra Settings
; ******************************************************
alias Extra-Settings { dialog $iif($dialog(Extra-Settings),-v,-m) Extra-Settings Extra-Settings }

dialog Extra-Settings {
  title "DC mBOT Extra Settings [F4]"
  size -1 -1 159 199
  option dbu
  icon $DC.Imgs(Extra.ico)
  check "Enable Extras", 22, 4 187 50 9
  button "&Help", 23, 74 187 40 10
  button "&Close", 24, 116 187 40 10, default cancel
  list 29, -6 -1 180 30, size
  list 30, 4 4 25 25, size
  text "Extra Settings", 32, 29 3 143 15
  text "Here are some PLUS features for you", 35, 30 17 142 10
  tab "Auto Voicer", 36, 3 32 153 152
  box "No Voice List", 38, 8 142 144 38, tab 36
  box "Devoicer", 37, 8 102 144 38, tab 36
  box "Voicer", 1, 8 48 144 52, tab 36
  check "Auto Voice to Chatters When...", 2, 13 58 88 10, tab 36
  text "Upon:", 3, 13 71 25 8, tab 36 right
  edit "", 4, 40 70 20 10, tab 36 center
  text "", 5, 61 71 25 8, tab 36 center
  edit "", 6, 87 70 20 10, tab 36 center
  text "Mins", 7, 110 71 18 8, tab 36
  radio "By Letters", 25, 78 85 36 10, tab 36
  radio "By Words", 8, 41 85 33 10, tab 36
  check "Auto Devoice After", 12, 13 112 57 10, tab 36
  text "Secs", 26, 94 125 20 8, tab 36
  edit "", 13, 71 112 20 10, tab 36 limit 2 center
  text "Mins Idle on Channel", 14, 94 113 55 8, tab 36
  edit "", 16, 71 124 20 10, tab 36 limit 3 center
  text "Check Idle Every", 15, 21 125 46 8, tab 36 right
  edit "", 9, 14 153 132 10, tab 36 autohs
  text "Syntax: 'Nickname@#Channel' separating by comma.", 10, 14 168 135 10, tab 36
  text "Method:", 11, 13 86 25 8, tab 36 right
  tab "Channel Limiter", 27
  box "", 39, 8 48 144 131, tab 27
  check "Enable Channel Limiter", 40, 14 55 70 10, tab 27
  check "Do not let anyone to set the channel limit", 41, 14 67 120 10, tab 27
  text "Offset:", 42, 11 82 41 8, tab 27 right
  edit "", 43, 55 81 20 10, tab 27 limit 1 center
  text "Check Method:", 44, 11 98 41 8, tab 27 right
  radio "Users Join/Part (Not recommended)", 45, 54 97 96 10, group tab 27
  radio "By Timer, every", 46, 54 108 52 10, tab 27
  edit "", 47, 106 108 20 10, tab 27 center
  text "Mins", 48, 128 109 20 8, tab 27
  text "Use Limiter for:", 49, 11 126 41 8, tab 27 right
  radio "All the channels where I am Op", 50, 54 125 92 10, group tab 27
  radio "Only in specified channels", 51, 54 136 83 10, tab 27
  text "Channels:", 52, 11 155 41 8, tab 27 right
  edit "", 53, 55 154 92 10, tab 27 autohs
  text "Syntax: '#Channel@Network' separating by comma.", 54, 14 168 134 10, tab 27
  tab "Other features", 55
  box "", 17, 8 48 144 54, tab 55
  check "&Weather", 18, 14 58 38 10, disable tab 55
  check "&Top10", 19, 66 58 32 10, tab 55
  check "&Ping", 20, 114 58 28 10, tab 55
  check "&IP", 21, 66 72 25 10, tab 55
  check "&Seen", 31, 14 72 29 10, tab 55
  check "Bot response on Nick-call (Random messages)", 28, 14 86 136 10, tab 55
  text "Note: Weather bot is disabled in this version. Because it had some bugs in its output and I haven't much time to debug it. I'll write a new weather bot for the next version.", 56, 11 112 137 30, tab 55
}

on 1:dialog:Extra-Settings:*:*:{
  if ($devent == init) {
    hOS EnableCloseBox $dialog($dname).hwnd false
    MDX MarkDialog $dname
    MDX SetMircVersion $version
    MDX SetBorderStyle $dname 29,30 simple
    MDX SetControlMDX $dname 30 Toolbar flat nodivider wrap list arrows > $Bars
    MDX SetColor $dname 29,30,32,35 background $rgb(199,199,199)
    MDX SetColor $dname 29,30,32,35 textbg $rgb(199,199,199)
    MDX SetColor $dname 29,32 text $rgb(65,141,255)
    MDX SetColor $dname 35 text $rgb(0,0,0)
    MDX SetFont $dname 32 +a 25 700 Ringbearer
    MDX SetFont $dname 35 +a 14 700 Arial
    did -i $dname 30 1 bmpsize 32 32
    did -i $dname 30 1 setimage icon normal $noqt($DC.Imgs(Extra.ico))
    did -a $dname 30 +a 1 $chr(9) $+ Extra Settings
    did -b $dname 18,29,30
    set %Weather-Cmd OFF
    if (%Auto-Voice == ON) { did -c $dname 2 }
    if (%Auto-Voice-Model == Words) { did -c $dname 8 | did -u $dname 25 | did -ra $dname 5 Words in | did -ra $dname 6 %Auto-Voice.WMins | did -ra $dname 4 %Auto-Voice.Words }
    if (%Auto-Voice-Model == Letters) { did -c $dname 25 | did -u $dname 8 | did -ra $dname 5 Letters in | did -ra $dname 6 %Auto-Voice.LMins | did -ra $dname 4 %Auto-Voice.Letters }
    if (%Auto-Devoice == ON) { did -c $dname 12 }
    if (%Auto-Devoice.Idle) { did -a $dname 13 $ifmatch }
    if (%Auto-Devoice-Check) { did -a $dname 16 $ifmatch }
    if (%NoVoices) { did -a $dname 9 $ifmatch }
    if (%Weather-Cmd == ON) { did -c $dname 18 }
    if (%Top10 == ON) { did -c $dname 19 }
    if (%Pingg == ON) { did -c $dname 20 }
    if (%IP-Loc-Cmd == ON) { did -c $dname 21 }
    if (%Extra-Set == ON) { did -c $dname 22 }
    if (%DC-mBOT-Talking-Cmd == ON) { did -c $dname 28 }
    if ($readini($DC.Dir(mBOT\xSeen.ini),settings,status) == 1) { did -c $dname 31 }
    if (%Limiter == ON) { did -c $dname 40 }
    if (%Limiter.NOE == ON) { did -c $dname 41 }
    if (%Limiter.OffSet) { did -a $dname 43 $ifmatch }
    if (%Limiter.Method == JP) { did -c $dname 45 }
    elseif (%Limiter.Method == T) { did -c $dname 46 }
    if (%Limiter.CheckTime) { did -a $dname 47 $ifmatch }
    if (%Limiter.UseFor == All) { did -c $dname 50 }
    elseif (%Limiter.UseFor == Some) { did -c $dname 51 }
    if (%Limiter.Channels) { did -a $dname 53 $ifmatch }
  }
  if ($devent == edit) {
    if ($did == 4) { 
      if ($did(8).state == 1) && ($did(25).state == 0) { set %Auto-Voice.Words $iif($did(4),$v1,500) }
      if ($did(8).state == 0) && ($did(25).state == 1) { set %Auto-Voice.Letters $iif($did(4),$v1,120) }
    }
    if ($did == 6) { 
      if ($did(8).state == 1) && ($did(25).state == 0) { set %Auto-Voice.WMins $iif($did(6),$v1,15) }
      if ($did(8).state == 0) && ($did(25).state == 1) { set %Auto-Voice.LMins $iif($did(6),$v1,15) }
    }
    if ($did == 9) {
      if ($did(9).text) { set %NoVoices $remove($ifmatch,$chr(32)) }
      else { unset %NoVoices }
    }
    if ($did == 13) { set %Auto-Devoice.Idle $iif($did(13),$v1,30) }
    if ($did == 43) { set %Limiter.OffSet $iif($did(43),$v1,5) }
    if ($did == 47) { set %Limiter.CheckTime $iif($did(47),$v1,5) }
    if ($did == 53) {
      if ($did(53).text) { set %Limiter.Channels $remove($ifmatch,$chr(32)) }
      else { unset %Limiter.Channels }
    }
  }
  if ($devent == sclick) {
    if ($did == 2) { set %Auto-Voice $iif($did(2).state == 1,ON,OFF) | .hfree -w AV.* }
    if ($did == 8) { set %Auto-Voice-Model Words | did -u $dname 25 | did -ra $dname 5 Words In | did -ra $dname 6 %Auto-Voice.WMins | did -ra $dname 4 %Auto-Voice.Words }
    if ($did == 12) { set %Auto-Devoice $iif($did(12).state == 1,ON,OFF) }
    if ($did == 18) { set %Weather-Cmd $iif($did(18).state == 1,ON,OFF) }
    if ($did == 19) { set %Top10 $iif($did(19).state == 1,ON,OFF) }
    if ($did == 20) { set %Pingg $iif($did(20).state == 1,ON,OFF) | $iif(%Pingg == ON,.enable,.disable) #Pinger }
    if ($did == 21) { set %IP-Loc-Cmd $iif($did(21).state == 1,ON,OFF) }
    if ($did == 22) { set %Extra-Set $iif($did(22).state == 1,ON,OFF) }
    if ($did == 23) { set %HFile Extra | Run_Help }
    if ($did == 25) { set %Auto-Voice-Model Letters | did -u $dname 8 | did -ra $dname 5 Letters In | did -ra $dname 6 %Auto-Voice.LMins | did -ra $dname 4 %Auto-Voice.Letters }
    if ($did == 28) { set %DC-mBOT-Talking-Cmd $iif($did(28).state == 1,ON,OFF) }
    if ($did == 31) { set %DC-Seen $iif($did(31).state == 1,ON,OFF) | .writeini $DC.Dir(mBOT\xSeen.ini) settings status $did(31).state }
    if ($did == 40) { set %Limiter $iif($did(40).state,ON,OFF) }
    if ($did == 41) { set %Limiter.NOE $iif($did(41).state,ON,OFF) }
    if ($istok(45 46,$did,32)) {
      set %Limiter.Method $iif($did(45).state,JP,T)
      did $iif($did(45).state,-b,-e) $dname 47
      if (%Limiter.Method == JP) { .timer.Limit.* off }
    }
    if ($istok(50 51,$did,32)) { set %Limiter.UseFor $iif($did(50).state,All,Some) }
  }
}

; [Auto Voice/Devoice and Limiter]
on *:RawMode:*:{
  if (*l* iswmcs $1) && (%Extra-Set == ON && %Limiter == ON && %Limiter.NOE == ON) { Limiter.Check $network $chan }
}

on *:Mode:*:{
  if (*l* iswmcs $1) && (%Extra-Set == ON && %Limiter == ON && %Limiter.NOE == ON) { Limiter.Check $network $chan }
}

on *:ServerMode:*:{
  if (*l* iswmcs $1) && (%Extra-Set == ON && %Limiter == ON && %Limiter.NOE == ON) { Limiter.Check $network $chan }
}

on *:Join:#:{
  if ($nick == $me) && (%Auto-Devoice == ON) {
    if (!%Auto-Devoice-Check) { set %Auto-Devoice-Check 30 }
    .timer.DV. [ $+ [ $network ] $+ [ $chan ] ] 0 %Auto-Devoice-Check /Chk-Idle $chan
  }
  if ($nick != $me) && (%Extra-Set == ON) && (%Limiter == ON) && (%Limiter.Method == JP) { Limiter.Check $network $chan }
}

on *:Op:#:{
  var %x = $+(AV,.,$network,.,$chan)
  if ($hget(%x,$opnick)) { .hdel %x $opnick }

  if ($opnick == $me) && (%Extra-Set == ON) && (%Limiter == ON) {
    if (%Limiter.Method == T) { Limit.ByTimer $network $chan }
    elseif (%Limiter.Method == JP) { Limiter.Check $network $chan }
  }
}

on *:Voice:#:{
  var %x = $+(AV,.,$network,.,$chan)
  if ($hget(%x,$vnick)) { .hdel %x $vnick }
}

on 1:Disconnect:{ .hfree -w $+(AV,.,$network,.*) | .timer.DV. [ $+ [ $network ] $+ [ * ] ] off | .timer.Limit. [ $+ [ $network ] $+ [ * ] ] off }
on *:Quit:{
  if ($nick == $me) { .hfree -w $+(AV,.,$network,.*) | .timer.DV. [ $+ [ $network ] $+ [ * ] ] off | .timer.Limit. [ $+ [ $network ] $+ [ * ] ] off }
  else { 
    var %c = 1
    while (%c <= $comchan($nick,0)) {
      var %x = $+(AV,.,$network,.,$comchan($nick,%c))
      if ($hget(%x,$nick)) { .hdel %x $nick }
      inc %c
    }
  }
  if ($nick != $me) && (%Extra-Set == ON) && (%Limiter == ON) && (%Limiter.Method == JP) { Limiter.Check $network $chan }
}

on *:Part:#:{
  if ($nick == $me) && ($hget(%x)) { .hfree $+(AV,.,$network,.,$chan) }
  else {
    var %x = $+(AV,.,$network,.,$chan)
    if ($hget(%x,$nick)) { .hdel %x $nick }
  }
  if ($nick != $me) && (%Extra-Set == ON) && (%Limiter == ON) && (%Limiter.Method == JP) { Limiter.Check $network $chan }
}

on *:Kick:#:{
  if ($knick != $me) {
    var %x = $+(AV,.,$network,.,$chan)
    if ($hget(%x,$nick)) { .hdel %x $nick }
  }
  if ($knick != $me) && (%Extra-Set == ON) && (%Limiter == ON) && (%Limiter.Method == JP) { Limiter.Check $network $chan }
}

on *:Ban:#:{
  if ($bnick != $me) {
    var %x = $+(AV,.,$network,.,$chan)
    if ($hget(%x,$nick)) { .hdel %x $nick }
  }
}

on *:Text:*:#:{
  if (* $+ $me $+ * iswmcs $strip($1-,burc)) && (%DC-mBOT-Talking-Cmd == ON) {
    if ($me isin $strip($1-,burc)) && (*Nakon* iswm $strip($1-,burc)) { msg $target $+($nick,:) I Like that :> }
    else { msg $target $+($nick,:) $read($DC.Dir(Doc\BT.txt)) }
  } 
  if ($nick !isreg $chan) || ($left($1,1) == %Trigger) || (%Extra-Set == OFF) || (%Auto-Voice == OFF) return
  if (%Auto-Voice == ON) && (!$NV.Check($nick,$chan)) { CheckForVoice $network $chan $nick $iif(%Auto-Voice-Model == Letters,$len($1-),$numtok($1-,32)) }
}

on *:Action:*:#:{
  if (* $+ $me $+ * iswmcs $strip($1-,burc)) && (%DC-mBOT-Talking-Cmd == ON) {
    if (*Slap* iswm $strip($1-,burc)) { describe $target Steals $+($nick,'s) hit and puts it back! }
    else { describe $target Says: $read($DC.Dir(Doc\BT.txt)) }
  }
  if ($nick !isreg $chan) || ($left($1,1) == %Trigger) || (%Extra-Set == OFF) || (%Auto-Voice == OFF) return
  if (%Auto-Voice == ON) && (!$NV.Check($nick,$chan)) { CheckForVoice $network $chan $nick $iif(%Auto-Voice-Model == Letters,$len($1-),$numtok($1-,32)) }
}

alias Limit.ByTimer {
  if ($me ison $2) && ($me isop $2) { Limiter.Check $1 $2 | .timer.Limit. [ $+ [ $1 ] $+ [ $2 ] ] 1 $calc(%Limiter.CheckTime * 60) /Limit.ByTimer $1 $2 }
}

alias Limiter.Check {
  if ($me !ison $2) { .timer.Limit. [ $+ [ $1 ] $+ [ $2 ] ] off | return }
  if ($1) && ($2) && ($me isop $2) && (%L. [ $+ [ $1 ] $+ [ $2 ] ] == $null) {
    if (%Limiter.UseFor == All) || (%Limiter.UseFor == Some && $istok(%Limiter.Channels,$+($2,@,$1),44)) {
      if (l !isincs $gettok($chan($2).mode,1,32)) || (l isincs $gettok($chan($2).mode,1,32) && $calc($chan($2).limit - $nick($2,0)) > $calc(%Limiter.OffSet / 2)) {
        if ($chan($2).limit != $calc($nick($2,0) + %Limiter.OffSet)) { mode $2 +l $calc($nick($2,0) + %Limiter.OffSet) }
        set -u5 %L. [ $+ [ $1 ] $+ [ $2 ] ] .
      }
    }
  }
}

alias NV.Check {
  if (!$1) return $false
  if ($istok(%NoVoices,$+($1,@,$2),44)) return $true
  elseif ($istok(%NoVoices,$1,44)) return $true
  return $false
}

alias NoVoice.List {
  if ($1) {
    if ($numtok(%NoVoices,44) < 1) { .notice $1 There is nothing to show. (The list is empty) | return }
    var %x = 1
    .notice $1 No-voice list begins:
    while (%x <= $numtok(%NoVoices,44)) { .notice $1 $+(%x,$chr(41)) Nickname: $qt($gettok($gettok(%NoVoices,%x,44),1,64)) -- Channel: $qt($iif($gettok($gettok(%NoVoices,44,%x),2,64),$v1,All)) | inc %x }
    .notice $1 End of No-voice list.
  }
}

alias CheckForVoice {
  if (%Auto-Voice == ON) && (%Extra-Set == ON) {
    if ($1 && $2 && $3 && $4) {
      var %x = $+(AV,.,$1,.,$2)
      if (!$hget(%x)) { .hmake %x 1000 }
      if (!$hget(%x,$3).item) {
        var %time = $calc($iif(%Auto-Voice-Model == Letters,%Auto-Voice.LMins,%Auto-Voice.WMins) * 60)
        hadd -mu [ $+ [ %time ] ] %x $3 $iif($4 isnum,$4,0)
        return
      }
      hinc -m %x $3 $iif($4 isnum,$4,0)
      var %len = $iif(%Auto-Voice-Model == Letters,%Auto-Voice.Letters,%Auto-Voice.Words)
      if ($hget(%x,$3) >= %len) {
        if ($3 !isreg $2) { .hdel %x $3 | return }
        if ($me isop $2) { mode $2 +v $3 | .hdel %x $3 }
      }
    }
  }
}

alias Chk-Idle {
  if ($me !ison $1) { .timer.DV. [ $+ [ $network ] $+ [ $1 ] ] off | return }
  if (%Auto-Devoice == ON) {
    if (!%Auto-Devoice.Idle) { set %Auto-Devoice.Idle 20 }
    var %idle = $calc(%Auto-Devoice.Idle * 60)
    var %x = $nick($1,0,v),%nicks
    while (%x) {
      if ($nick($1,%x,v).idle >= %idle) && ($nick($1,%x,v) isvoice $1) && ($me isop $1) && ($nick($1,%x,v) != $me) { %nicks = $addtok(%nicks,$nick($1,%x,v),32) }
      dec %x
    }
    if ($numtok(%nicks,32) > 0) { mode $1 $+(-,$str(v,$numtok(%nicks,32))) %nicks }
  }
}

; [IP Locator]
alias locate {
  if ($1) { 
    sockclose locate
    sockopen locate www.melissadata.com 80
    sockmark locate $1-
    msg %IP-Chan $+(Locating,$chr(32),$1,$chr(44),$chr(32),Please wait...)
  }
}
alias striphtml {
  var %x, %i = $regsub($1-,/(^[^<]*>|<[^>]*>|<[^>]*$)/g,$null,%x), %x = $remove(%x,&nbsp;)
  return %x
}
alias -l endlocate {
  if (%ip) {
    msg %IP-Chan Transaction completed, Results for: %ip
    var %msg = $+(2Country:,3,$chr(32),,$iif($ToPascal(%country),$ifmatch,-),) $+(4,$str($chr(124),2)) $+(2City:,3,$chr(32),,$iif($ToPascal(%city),$ifmatch,-),) $+(4,$str($chr(124),2)) $+(2State/Region:,3,$chr(32),,$iif($ToPascal(%state),$ifmatch,-),) $+(4,$str($chr(124),2)) $+(2ISP:,3,$chr(32),,$iif($ToPascal(%isp),$ifmatch,-),)
    msg %IP-Chan $iif(c isincs $chan(%IP-Chan).mode,$strip(%msg,burcmo),%msg)
  }
  elseif (!%ip) && (!%err) { msg %IP-Chan No match were found... }
  unset %ip %city %state %country %isp %IP-Chan %err %msg
}

on *:sockopen:locate:{
  if ($sockerr > 0) { msg %IP-Chan Socket Read Error! Please try later... | unset %IP-Chan | return }
  sockwrite -n $sockname GET $+(/lookups/iplocation.asp?ipaddress=,$sock($sockname).mark) HTTP/1.1
  sockwrite -n $sockname Host: $+(www.melissadata.com,$str($crlf,2))
  sockwrite -n $sockname Connection: Keep-Alive
}
on *:sockread:locate:{
  if ($sockerr > 0) { msg %IP-Chan Socket read Error! Please try later... | unset %IP-Chan | return }
  var %q
  sockread %q
  tokenize 32 $striphtml(%q)
  if (*is not valid* iswm $1-) { msg %IP-Chan Syntax is not valid! Syntax: $+(%Trigger,ip) 127.0.0.1 | set %err 1 | .sockclose locate | return }
  else {
    if (*IP Address*.*.*.* iswm $1-) && (*Protocol* !iswm $1-) { set %ip $remove($1-,IP Address,$chr(9)) }
    if (*City* iswm $1-) && (*Protocol* !iswm $1-) { set %city $right($remove($1-,$chr(9)),-5) }
    if (*State Or Region* iswm $1-) && (*Protocol* !iswm $1-) { set %state $remove($1-,State or Region,$chr(9)) }
    if (*Country* iswm $1-) && (*Protocol* !iswm $1-) { set %country $remove($1-,Country,$chr(9)) }
    if (*ISP* iswm $1-) && (*Protocol* !iswm $1-) { set %ISP $remove($1-,ISP,$chr(9)) }
  }
  .timer.locate -o 1 0 /endlocate $sock($sockname).mark
}

alias ToPascal {
  if ($1-) {
    var %in = $1-,%out
    var %x = 1,%y
    ;var %excepts = in,out,the,of,off,god,man,up,get,set,let,if,me,you,are,am,i,why,can,isp
    var %a = ` 1 2 3 4 5 6 7 8 9 0 - = ; ' , . / \ ~ ! @ # $ % ^ & * ( ) _ + : " < > ? |
    while (%x <= $numtok(%in,32)) {
      if ($istok(%a,$left($gettok(%in,%x,32),1),32)) { %y = $gettok(%in,%x,32) | goto Next }
      ;if ($len($gettok(%in,%x,32)) < 4) && (!$istok(%excepts,$lower($gettok(%in,%x,32)),44)) { %y = $upper($gettok(%in,%x,32)) }
      else { %y = $+($upper($left($gettok(%in,%x,32),1)),$lower($right($gettok(%in,%x,32),-1))) }
      :Next
      if (%out == $null) { %out = %y }
      else { %out = $+(%out,$chr(32),%y) }
      inc %x
    }
    return %out
  }
}
